import random
import matplotlib.pyplot as plt
import numpy as np

def iterations_to_five():
    
    iterations = 1
    while True:
        random_float = random.random()
        random_integer = int(10*random_float)
        if random_integer == 5:
            break
        else:
            iterations += 1

    return iterations

num_trials = 100000
trials_list = []
for trial in range(num_trials):
    iterations = iterations_to_five()
    trials_list.append(iterations)

mean_list = np.mean(trials_list)

print('Mean Number of Iterations =', mean_list)


predict_list = []
iterations_list = list(range(1, 100))
for iterations in iterations_list:
    predict = 0.9**(iterations-1)*0.1*num_trials
    predict_list.append(predict)


plt.hist(trials_list,bins=200)
plt.xlabel('Number of Iterations to Produce Integer 5')
plt.ylabel('Number of Trials')
plt.plot(iterations_list,predict_list)
plt.show()
                         
